local super = require "TableColumn"

FractionBarColumn = super:new()

local defaults = {
    max = 100,
}

local nilDefaults = {
    'value', 'paint',
}

local getterNames = {'max', 'value', 'paint'}

local inspectorInfo = {
    {'number', {'max'}, 'Max'},
    {'KeyArtifact', {'value'}, 'Value'},
    {'Color', {'getPaint:setPaint', custom = 'hasExplicitPaint:'}, 'Color'},
}

function FractionBarColumn:new()
    self = super.new(self)
    
    for k, v in pairs(defaults) do
        self:addProperty(k, v)
    end
    for _, k in pairs(nilDefaults) do
        self:addProperty(k)
    end
    
    self.stamp = FractionBarStamp
    self.getterNames = getterNames
    self.inspectorInfo = inspectorInfo
    
    return self
end

-- NOTE: Version 1.1.3 and earlier saved a 'thickness' property.
function FractionBarColumn:unarchiveThickness(archived)
end

function FractionBarColumn:unarchived()
    local dataset = self:getDataset()
    if dataset then
        if self:getProperty('value') == nil then
            local avoidingFields = self:peerPropertyKeyArtifactValues(FractionBarColumn, 'value')
            local field = dataset:pickField('number', avoidingFields)
            if field then
                self:setProperty('value', KeyArtifact:new(field))
                self:setTitle(field)
            end
        end
    end
    super.unarchived(self)
end

function FractionBarColumn:drawCell(canvas, rect, max, value, paint)
    rect = rect:insetXY(0, rect:height() / 6)
    local parent = self:getParent()
    FractionBarStamp(canvas, rect, max, value, parent:getEmptyFillPaint(), paint or parent:getAccentPaint())
end

function FractionBarColumn:getDefaultPaint()
    return self:getParent():getAccentPaint()
end

return FractionBarColumn
